<?php
namespace vatico\src\base;
//=============================================================================
/// file AutoLoader.php
///  @brief      アプリケーションメインの基底クラス
///  @author     inuvatico
///  @date        2020/07/19
///  @version     1.0
///  @copyright   2020 inuvatico
///  @par (new/Add/Change :  2020/07/19)
///  Copyright(c) 2020 inuvatico
///  This software is released under the MIT License.
///  http://opensource.org/licenses/mit-license.php
//=============================================================================
/**
 * オートローダー
 */
class AutoLoader {

    private static $m_inst = null; //!< AutoLoaderシングルトンオブジェクト

    /**
     * インスタンスの取得
     */
    public static function getInst(){
        if(AutoLoader::$m_inst==null){
            AutoLoader::$m_inst =  new AutoLoader();
            spl_autoload_register(array(AutoLoader::$m_inst, 'loader'));
        }
        return AutoLoader::$m_inst;
    }

    /**
     * インスタンスの初期設定
     */
    public static function setUp(){
        return AutoLoader::getInst();
    }

    /**
     * 検索パスのセット
     */
    public static function setPath($path){
        return AutoLoader::getInst()->_setpath($path);
    }

    private $m_paths = array(); //!<　検索パスリスト
    
    /**
     * 検索パスのセット
     */
    private function _setpath($path){
        $path = realpath($path);
        $path=str_replace("\\", '/',$path);
        //echo $path."<br>";
        $path.="/";
        if(!in_array($path,$this->m_paths)){
            $this->m_paths[] = $path;
        }
        return sizeof($this->m_paths);
    }
    /**
     * オートローダーのコールバック
     */
    public function loader($class){

        $class=str_replace('\\','/',$class);

        foreach($this->m_paths as $pats) {
            $pats.=$class.".php";
            if (is_file($pats)) {
                require $pats;
                return true;
            }            
        }
    
       print("<br><br>----not find ----------------------<br>");
        foreach($this->m_paths as $pats) {
            print($pats.$class.".php");            
            print("<br>");
        }
        print("<br>--------------------------<br>");
    
    }

}
?>
