<?php
namespace vatico\src\base;
//=============================================================================
///  @file Response.php
///  @brief      レスポンスを作成する
///  @author     inuvatico
///  @date        2018/07/19
///  @version     1.0
///  @copyright   2018 inuvatico
///  @par (new/Add/Change :  2018/07/19)
// Copyright(c) 2018 inuvatico
// This software is released under the MIT License.
// http://opensource.org/licenses/mit-license.php
//=============================================================================
/**
 * レスポンスベースクラス
 */
class Response {

	const HTTP = 'HTTP/1.1 ';
	
  	/**
	 * レスポンスをを返す
	 */
	public static function Send( $content){
    	$statusCode = 200;
    	$statusMsg = 'OK';
		// $obj = new CResponse();
		header(self::HTTP . $statusCode . ' ' . $statusCode);
    	print $content;
	}
  	/**
	 * エラーを返す 
	 */
	public static function SendErr($e,$isDisp){
    	$statusCode = 404;
    	$errMessage = $isDisp ? $e->getMessage() : 'FILE NOT FOUND.';
    	$errMessage = htmlspecialchars($errMessage, ENT_QUOTES, 'UTF-8');
		$html=""
		."<!DOCTYPE html>"
		."<html>"
		."<head>"
		."<meta charset='UTF-8' />"
		."<title>HTTP 404 Error</title>"
		."</head>"
		."<body>"
		."{$errMessage}"
		."</body>"
		."</html>"
		."";
    	header(self::HTTP . $statusCode . ' ' . $errMessage);
    	print $html;
	}
}
