<?php
namespace vatico\src\uty;
//=============================================================================
///  @file DownLoad.php
///  @brief  CSVファイルの読み込み
///  @author     inuvatico
///  @date        2020/07/2
///  @version     1.0
///  @copyright   2018 inuvatico
///  @par (new/Add/Change :  2018/07/19)
// Copyright(c) 2018 inuvatico
// This software is released under the MIT License.
// http://opensource.org/licenses/mit-license.php
//=============================================================================

// 参考：http://wordpress.ideacompo.com/?p=11777

/**
 * ダウンロードクラス
 */
class Download{

   /**
    * Zipのダウンロード
    */
    static function zip($path, $is_unlink=false)
    {
        header('Content-Type: application/zip');
        return self::send($path, $is_unlink);
    }
   /**
    * テキストのダウンロード
    */
    static function text($path, $is_unlink=false){
        header('Content-Type: application/plain');
        return self::send($path, $is_unlink);
    }
    

   /**
    * ダウンロード
    */
    private static function send($path, $is_unlink=false)
    {
        header('Content-Disposition: attachment; filename="'.basename($path).'"');
        header('Content-Length: ' . filesize($path));
        $content = file_get_contents($path);
        if($is_unlink) {
            unlink($path);
        }
        return $content;
    }    

}