<?php
namespace uty;
//=============================================================================
///  @file VaticoPhp.php
///  @brief      
///  @author     inuvatico
///  @date        2020/07/19
///  @version     1.0
///  @copyright   2020 inuvatico
///  @par (new/Add/Change :  2018/07/19)
// Copyright(c) 2020 inuvatico
// This software is released under the MIT License.
// http://opensource.org/licenses/mit-license.php
//=============================================================================
use Michelf\MarkdownExtra as MarkdownExtra;
const CSV_INDEX_REQUEST = 0;
const CSV_INDEX_PARAM = 1;
const CSV_INDEX_CONTENT = 2;
const CSV_INDEX_DESC = 3;

/**
 * VaticoPhpアプリケーションコントローラー 
 */
class MDDoc extends  \vatico\src\base\Controller
{
	private $m_mainManuCsvPath;
	private $m_contentsCsvPath;
	private $m_contentRootPath;

	/**
	 * メインメニューCsvファイルのパスを設定する
	 */
	public function setMainMenuCsvPath($path) {$this->m_mainManuCsvPath =$path;}

	/**
	 * Csvファイルのパスを設定する
	 */
	public function setContentCsvPath($path) {$this->m_contentsCsvPath =$path;}
	/**
	 * マークダウンファイルのルートフォルダを指定する
	 */
	public function setContentRootPath($path) {$this->m_contentRootPath = $path;}

	/** コンストラクタ	*/
	public function __construct()
	{
		$this->setMainMenuCsvPath(dirname(__FILE__) . "/../menu.csv");
		$this->setContentCsvPath(dirname(__FILE__) . "/contents.csv");
		$this->setContentRootPath(dirname(__FILE__));
	}


	/**
	 * アプリケーションの実行
	 */
	public function run()
	{

		$TempContent = array();

		//----------------------------------------------
		// コンテンツメニューを作成する&設定
		//----------------------------------------------
		if(is_file($this->m_mainManuCsvPath)){
			// コンテンツリストの読み込み		
			$TopMenu = new \vatico\src\uty\LoadCSV();
			$TopMenu->set($this->m_mainManuCsvPath);
			$size = 0;
			foreach ($TopMenu->getCSV() as $line) {
				$path = "/index.php/".$line[0] ;
				$mainMenu[$size] = array(
									'path' => "/index.php/".$line[0],
									'desc' => $line[1],
						);
				$size++;
			}
			$TempContent['mainMenu'] = $mainMenu;
		}

		//----------------------------------------------
		// コンテンツリストの読み込み		
		//----------------------------------------------
		$CCsv = new  \vatico\src\uty\LoadCSV();
		$CCsv->set($this->m_contentsCsvPath);
		
		//----------------------------------------------
		// コンテンツリストを連想配列に変換
		//----------------------------------------------
		$size = 0;
		foreach ($CCsv->getCSV() as $line) {
			$path = "/index.php/".$line[CSV_INDEX_REQUEST].":".$line[CSV_INDEX_PARAM] ;
			$menuList[$size] = array(
								'path' => $path,
								'desc' => $line[CSV_INDEX_DESC],
								'param' => $line[CSV_INDEX_PARAM],
								'target' => $line[CSV_INDEX_CONTENT]
					);
			$size++;
		}

		//----------------------------------------------
		// コンテンツメニューを作成する
		//----------------------------------------------
		if($size>0){
			// コンテンツのインデックスを取得
			$index = array_search( $this->m_param, array_column($menuList, 'param'));
			if( $index === false) {
				$index  = 0;
			}
    	    $path = $this->m_contentRootPath."/".$menuList[$index]['target'];
			
			// マークダウンファイルの読み込み
			if( is_file($path) ) {
				$md = file_get_contents($path);
    	    	$TempContent['content'] = MarkdownExtra::defaultTransform($md);
			}

			// 下部メニューの作成
			{
				$TempContent['menu'] = $this->getListMenu($menuList);
				if($index+1 < sizeof($menuList)) {
					$TempContent['next'] = array('path' =>  $menuList[$index+1]['path']);	
			}
				if($index > 0) {	
					$TempContent['prev'] = array('path' =>  $menuList[$index-1]['path']);	
				}
			}
		}
        ob_start();
        ob_implicit_flush(0);
        require (dirname(__FILE__)."/../uty/TempSmp.php");
        $content = ob_get_clean();
        return $content;
	}

    /**
     * メインメニューを作成する
     * @param $list['path'] URL   
     * @param $list['desc'] 説明   
     */
    public function getMainMenu($list){
	}

	/**
     * リストメニューを作成する
     * @param $list['path'] URL   
     * @param $list['desc'] 説明   
     */
    public function getListMenu($list){
        $menu = "<ul class='list_menu'>";
        foreach ($list as $line) { 
            $menu = $menu.sprintf ("<li><a %s href=%s>%s</a></li>",
            'style=" text-decoration: none; outline: none;"',
            $line['path'],
            $line['desc']);
        }
        $menu = $menu. "</ul>";
        return $menu;
    }
}


//------------------------------------------------
//ファクトリーを無名関数で渡す
return function()
{ 
	return new MDDoc(); 
}	

?>
