<?php 
//=============================================================================
///  @TempContent.php
///  @brief  このファイルはHTMLを出力するためのテンプレートです。以下のパラメータをとります
///  @param $TempContent['title']   このページのタイトル
///  @param $TempContent['mainMenu']　メインメニュー
///  @param $TempContent['content']   本文
///  @param $TempContent['prev']    前のページ
///  @param $TempContent['next']    次のページ
///  @param $TempContent['menu']    関連するコンテンツのメニュー
///
///  @author     inuvatico
///  @date        2020/07/19
///  @version     1.0
///  @copyright   2020 inuvatico
///  @par (new/Add/Change :  2018/07/19)
// Copyright(c) 2020 inuvatico
// This software is released under the MIT License.
//=============================================================================
?>


<!doctype html>
<html lang="ja">

<head>
  <meta charset="UTF-8">
  <title>sample</title>

  <!-- GuthubのCDNを使用しています -->
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/github-markdown-css@3.0.1/github-markdown.min.css"> 

  <style>
    /**
     * 変数などの定義
     */
    :root {
      --title-text:"vatico-php";			/* タイトルテキストの色*/
      --title-color: #0000ff; 				/* タイトルテキストの色 */
      --main-bg-color: #AADDff; 			/* 背景色*/
      --menufont-color:#00aa44; 			/* メニューの色 */
      --footer-text:"vatico-php ver 1.2"; 	/*フッターのテキスト */
    }
    html {
      min-height: 100%;
      font-size: 100%;
      margin: 32px ;
      padding: 16px  ;
    }

    body {
      background-color: var(--main-bg-color);
      font-size: 1.25em;
    }

    /*****************************************
    * マークダウンの調整
    */
    
    /**
     * 見出し# の定義
     */
    h1 {
      font-size: 2.2em;
      line-height: 1.8;
      border-bottom-width: 2px;
      border-bottom-style: solid;
    }

    /**
     * 見出し## の定義
     */
    h2 {
      line-height: 1.8;
      font-size: 1.4em;
      border-bottom-width: 1px;
      border-bottom-style: solid;
    }

    /**
     * code エリアの定義
     */
    pre {
      font-size: 0.9em;
      padding: 8px  ;
      color: #ffffff;
      font-style:normal;
      background: #000000;
    }

    /**
     * テーブルの定義
     */
    table {
      border-collapse: collapse;
	    border: 1px solid;
    }

    table > thead > tr > th {
	    text-align: left;
	    border-bottom: 2px solid;
    }

    table > thead > tr > th,
    table > thead > tr > td,
    table > tbody > tr > th,
    table > tbody > tr > td {
	  padding: 5px 10px;
	    border-right: 1px solid;
    }

    table > tbody > tr + tr > td {
	    border-top: 1px solid;
    }

    .list_menu{
      font-size: 1.2em;
    }
    li{
      padding: 4px;
    }

    /*****************************************
    * その他
    */
    /**
     * フォーカス時の挙動
     */
    :focus {
      font-weight: bolder;
    }

    /** 
     * メインタイトル 
     */
     
    .main_title {
      margin: 32px auto;
      padding: 10px;
      font-size: 5rem;
      line-height: 2.4rem;
      font-weight: bolder;
      color: var(--title-color);
    }
    .main_title:focus {
      font-weight: bolder;
    }
    .main_title::before {
      content:var(--title-text);
    }


    /** 
     * メニューフォント
     */
    .menufont {
      font-size: 2.4rem;
      color: var(--menufont-color);
      font-style: italic;
      text-shadow: 1px 1px 0 #afF, -1px -1px 0 #afF,
        -1px 1px 0 #afF, 1px -1px 0 #afF,
        0px 1px 0 #afF, 0-1px 0 #afF,
        -1px 0 0 #afF, 1px 0 0 #afF;
    }

    /**
     * フッター
     */
    .footerfont {
      color: #000066;
      font-style: italic;
      font-weight: lighter;
      font-style:small;
	    padding:15px 0px 5px 0px;	
      text-align: center;
    }
    .footerfont::before {
      content:var(--footer-text);
    }


    .main_menu {
      display: inline-block;
      margin: 16px;
    }
    .main_menu:hover {
      font-weight: bolder;
    }

  </style>
</head>


<body>

<div >
  <a  href="/index.php" class="main_title" style="text-decoration: none; outline: none;"> </a>
</div>

<?php
  /**
   *  コンテンツタイトル表示
   */
  if (isset($TempContent['title'])) {
    echo $TempContent['title'];
  }
  ?>


<div style="text-align:left; ">
    <?php
    /**
     * メインメニューの作成 
     */
    if (isset($TempContent['mainMenu'])) {
      $str = <<< EOM
      <div class=" main_menu"  >
      <a href="%s" class="menufont" style=" text-decoration: none; outline: none;">%s</a>
      </div>
EOM;
      foreach ($TempContent['mainMenu'] as $line) {
        printf($str, $line['path'], $line['desc']);
      }
    }
    ?>
  </div>





  <?php
  /**
   * コンテンツの作成
   */
  if (isset($TempContent['content'])) echo $TempContent['content'];
  ?>

  <div class="menufont" style="text-align:center;">
    <?php
    /**
     * prev/nextの作成
     */
    $form = '<a href="%s"class="menufont" style="outline: none;">%s</a>';
    $prev = "";
    $delimiter = "";
    $next = "";
    if (isset($TempContent['prev']) || isset($TempContent['next'])) {
        $prev = "--";
        $delimiter = "/";
        $next = "--";
    
      if (isset($TempContent['prev'])) {
        $prev = sprintf($form, $TempContent['prev']['path'], 'prev');
      }
      if (isset($TempContent['next'])) {
        $next = sprintf($form, $TempContent['next']['path'], 'next');
      }
    }
    echo $prev;
    echo $delimiter;
    echo $next;
    ?>

  </div>

  <?php
  /**
   * メニューの作成
   */
  if (isset($TempContent['menu'])) echo $TempContent['menu'];
  ?>

  <br>
  <footer>
      <address  class="footerfont">
      </address>
  </footer>


</body>

</html>