<?php

namespace vatico\src\base;
//=============================================================================
///  @file Dispatch.php
///  @brief      リクエストからコントローラーへのパスを作成する
///  @author     inuvatico
///  @date        2018/07/19
///  @version     1.0
///  @copyright   2018 inuvatico
///  @par (new/Add/Change :  2018/07/19)
// Copyright(c) 2018 inuvatico
// This software is released under the MIT License.
// http://opensource.org/licenses/mit-license.php
//=============================================================================

/**
 * リクエストからコントローラーパスとパラメータを取得する
 */
class Dispatch
{
	/**
	 * ファクトリー
	 */
	public static function get(
		$path,  	//< アプリケーションルートへのパス
		$Contents,	//< コンテンツ(API)リスト
		$req		//< リクエスト
	) {
		//--------------------------------
		// リクエストからAPIとパラメータに分割
		//--------------------------------
		$api = $req; //API名の取得
		$param = ""; //パラメータの取得
		{
			$pos = strpos($api, ":");
			if ($pos !== false) { //パラメータついてます
				$api = substr($api,  0, $pos); //API名の取得
				$param = substr($req,  $pos + 1); //パラメータ部の取得
			}
		}

		// コントローラー名の取得
		$ControllerPath = null;
		$root = null;
		foreach ($Contents as $line) {
			//ルートコントローラを取得
			if ($line[0] == "ROOT") {
				$root = $line[2];
			}
			if ($line[0] == "API") {
				if ($line[1] == $api) {
					$ControllerPath = $line[2];
				}
			}
		}
		if ($ControllerPath == null) {
			$ControllerPath = $root;
		}

		if (($path != null) & ($ControllerPath != null)) {
			$ControllerPath = $path . "/" . $ControllerPath;
		}

		$obj = new Dispatch(); {
			$obj->m_ControllerPath = $ControllerPath;
			$obj->m_api = $api;
			$obj->m_param = $param;
		}
		return $obj;
	}

	private $m_ControllerPath = null; 	//!< コントローラーへのパス
	private $m_api = null; 				//!< api
	private $m_param = null; 			//!< パラメータ

	public function getControllerPath()
	{
		return $this->m_ControllerPath;
	}
	public function getApi()
	{
		return $this->m_api;
	}
	public function getParam()
	{
		return $this->m_param;
	}

}
