<?php
namespace vatico\src\base;
//=============================================================================
///  @file Request.php
///  @brief      リクエスト(URL)関係を扱うクラス
///  @author     inuvatico
///  @date        2018/07/19
///  @version     1.0
///  @copyright   2018 inuvatico
///  @par (new/Add/Change :  2018/07/19)
// Copyright(c) 2018 inuvatico
// This software is released under the MIT License.
// http://opensource.org/licenses/mit-license.php
//=============================================================================
class Request {
  	/**
	* リクエストされたURIを取得
	*/
	public static function getRequestUri(){
    	return $_SERVER['REQUEST_URI'];
  	}
  	/**
	* ベースのURLを取得
	*/
	public static function getBaseUrl(){
		$scriptName = $_SERVER['SCRIPT_NAME'];
		$requestUri = Request::getRequestUri();
		$ret = null;
		if (0 === strpos($requestUri, $scriptName)) {
			$ret = $scriptName;
		} else if (0 === strpos($requestUri,dirname($scriptName))
		){
			$ret = rtrim(dirname($scriptName), '/');
		}

		if($ret==null) $ret = '';
		return $ret;

	}
  	/**
	* リクエストパスの取得(ベース部分が削除されたもの)
	*/
 	public static function getPath(){
    	$base_url = Request::getBaseUrl();
    	$requestUri = Request::getRequestUri();

		//'?'以降の文字列を取得(パラメータ)
    	if (false !== ($sp = strpos($requestUri, '?'))){
      		$requestUri = substr($requestUri, 0, $sp); 
    	}
		//ベースURL以降の文字列を取得(API文字)
     	$path = (string)substr($requestUri,strlen($base_url));
		
		if($path==null){
			$path = '/';
		} else {
			if($path[0]=='/'){ // 先頭の'/' を削除
				$path = (string)substr($path,1);
			}
		}
		return $path;
  	}
}
