<?php
namespace vatico\src\base;
//=============================================================================
///  @file AppBase.php
///  @brief      アプリケーションメインの基底クラス
///  @author     inuvatico
///  @date        2018/07/19
///  @version     1.0
///  @copyright   2018 inuvatico
///  @par (new/Add/Change :  2018/07/19)
// Copyright(c) 2018 inuvatico
// This software is released under the MIT License.
// http://opensource.org/licenses/mit-license.php
//=============================================================================
//------------------------------------
// ユーティリティーの読み込み
//------------------------------------
require_once(dirname(__FILE__) . '/../uty/LoadCSV.php');

//------------------------------------
// 基幹モジュールの読み込み
//------------------------------------
require_once 'Request.php';
require_once 'Dispatch.php';
require_once 'Response.php';
require_once 'Controller.php';
require_once 'AutoLoader.php';

use vatico\src\base;

class FileNotFoundException extends \Exception
{
}; //例外通知クラス:ファイルが見つからない

/**
 * アプリケーションのベース
 */
class AppBase
{
	protected $m_bdisplayErrors = false; //!< true/false : エラー表示のオン／オフ

	/**
	 * サーチパスの設定
	 */
	public function setLoderPath($path)
	{
		$count = AutoLoader::setPath($path);
		if ($count <= 1) {
			$this->setAutoLoder();
		}
	}

	/**
	 * vatico-phpで使用するパス
	 */
	public function setAutoLoder()
	{
		AutoLoader::setPath(dirname(__FILE__));
		AutoLoader::setPath(dirname(__FILE__) . "/..");
		AutoLoader::setPath(dirname(__FILE__) . "/../..");
		AutoLoader::setPath(dirname(__FILE__) . "/../../..");
		AutoLoader::setPath(dirname(__FILE__) . "/../../external");
		AutoLoader::setPath(dirname(__FILE__) . "/../../external/Michelf");
	}

	/**
	 * コンストラクタ
	 */
	public function __construct($dspErr = false)
	{
		$sv = $_SERVER['SERVER_NAME'];
		if (strpos($sv, 'dev') !== false) {
			$dspErr = true; //エラー表示を許可
		}
		$this->setDisplayErrors($dspErr);
	}

	/**
	 * 処理の開始
	 */
	protected function start(
		$appRoot,  //< アプリケーションのルート
		$Contents  //< コンテンツのリスト
	) {
		try {
			//---------------------------------------
			//リクエスト(URI)からファンクションパスを取得	
			//---------------------------------------
			$fpath = Request::getPath();

			//---------------------------------------
			//APIからコントローラを取得
			//---------------------------------------
			$content = null;
			$Dispatch = Dispatch::get($appRoot, $Contents, $fpath);
			if ($Dispatch->getControllerPath() != null) {
				if (file_exists($Dispatch->getControllerPath())) {
					$CreateFunc = require $Dispatch->getControllerPath(); //ファクトリ関数を取得
					if ($CreateFunc === (int) 1) { //ファクトリ関数名が受け取れなかった
						throw new FileNotFoundException(' Controller err:100' . ' NOT FOUND.  ' .   "  path:" . $fpath);
					}
					$Controller = $CreateFunc(); //コントローラーの作成
					$Controller->init($Dispatch->getApi(), $Dispatch->getParam());
					$content = $Controller->run();
				}
			}
			//-----------------------------------------
			//レスポンスを返す
			//-----------------------------------------
			if ($content != null) {
				Response::Send($content);
				return;
			}
			throw new FileNotFoundException(' Controller err:101' . ' NOT FOUND.  ' .   "  path:" . $fpath);
		} catch (FileNotFoundException $e) {
			$this->dispErrorPage($e, $this->m_bdisplayErrors);
			//} catch (CAuthorizedException $e) {
			//	$this->dispErrorPage($e,$this->m_bdisplayErrors);
		} catch (\Exception $e) {
			//print "catch";
			$this->dispErrorPage($e, $this->m_bdisplayErrors);
		}
	}

	/**
	 * メイン処理:オーバーライドする
	 */
	public function run()
	{
		$api_path = dirname(__FILE__) . "../../app";
		$this->start($api_path, $this->getDefinition);
	}

	//==============================================
	// エラー関係	
	//==============================================
	/**
	 * エラー出力フラグの設定 : php.iniの更新
	 * 　- ini_set : php.ini 内の値を上書き(プロセス終了時にもとに戻る)
	 */
	protected function setDisplayErrors($bDspErr)
	{
		$bDspErr = true; //_vatico_
		$this->m_bdisplayErrors = true;
		if ($bDspErr) {
			ini_set('display_errors', 1);
			ini_set('error_reporting', E_ALL);
		} else {
			ini_set('display_errors', 0);
		}
	}
	/**
	 * エラー出力フラグの設定 : php.iniの更新
	 * 　- ini_set : php.ini 内の値を上書き(プロセス終了時にもとに戻る)
	 */
	public function isDisplayErrors()
	{
		return $this->m_bdisplayErrors;
	}
	/**
	 * エラーページの表示
	 */
	protected function dispErrorPage($e, $isDisp)
	{
		Response::SendErr($e, $isDisp);
	}
}
