<?php
namespace vatico\src\uty;
//=============================================================================
///  @file LoadCSV.php
///  @brief  CSVファイルの読み込み
///  @author     inuvatico
///  @date        2018/07/19
///  @version     1.0
///  @copyright   2018 inuvatico
///  @par (new/Add/Change :  2018/07/19)
// Copyright(c) 2018 inuvatico
// This software is released under the MIT License.
// http://opensource.org/licenses/mit-license.php
//=============================================================================
class LoadCSV{
    private $m_list=null; //!< 読み込んだCSV情報
	public function getCSV(){
		return $this->m_list;
	}
	/**
	 * コンストラクタ
	 */
	public function __construct(){}
	
	/**
	 * デバック用プリント
	 */
	public function dprint(){
		foreach ($this->m_list as $line) {
			print count($line) .":";
			for($i = 0 ; $i < count($line); $i++){ 
			   print $i."(".$line[$i] .")";
			}					
			print "<br>";
		}
	}
	
	/**
	 * CSVファイルの読み込み
	 */
	public function set($filepath){
		$this->m_list = $this->load($filepath);
	}
	/**
	 * CSVファイルの読み込み
	 */
	public static function load($filepath){
		$list = array();
		$csv = new \SplFileObject($filepath , 'r');
		{
			$csv->setFlags(\SplFileObject::READ_CSV);
			$skip=0;
			foreach ($csv as $line) {
				if(is_null($line[0])) 
					continue;
				if(strpos($line[0], '//') ===false ) //コメント行のチェック
				{
					//タブは取り除く
					$str = str_replace('	', '', $line);
					
					//前後のスペースを取り除く
					for($i = 0 ; $i < count($str); $i++){ 
						$str[$i] = trim($str[$i]);
					}					
					$list[]=$str;
				}else{
					$skip = $skip+1;
				}				
			}
		}
		return $list;
	}
}	



